%put NOTE: You have called the macro _DECODA, 2005-06-08;
%put NOTE: Copyright (c) 2001-2005 Rodney Sparapani;
%put;

/*
Author:  Rodney Sparapani <rsparapa@mcw.edu>
Created: 2001-00-00

This file is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

In short: you may use this file any way you like, as long as you
don't charge money for it, remove this notice, or hold anyone liable
for its results.
*/

/* _DECODA Documentation
    REQUIRED Parameters  

    INFILE=                 CODA index file 
                            (NAMEIndex.txt, NAME.ind or NAME.ind.txt)
    FILE=INFILE             alias
    OUT=                    SAS dataset created
                            
    Specific OPTIONAL Parameters
                            
    CHAINS=                 the number of CODA chain files
                            (NAME#.txt, NAME#.out or NAME#.out.txt)
    CHAIN#=                 if the CODA chain files do not follow the
                            standard naming convention, then you
                            must manually list them here (up to 10)
    GSFMODE=REPLACE         default GSFMODE for first graph
    MU0=0                   default location for tests/tables
    STATS=                  if set to a SAS variable name or a list of SAS 
                            variable names, then summarize/graph those;
                            if set to anything else, produce summaries
                            and graphs for all SAS variables;
                            otherwise, PROC CONTENTS
    TAIL=txt                default file extension for CODA chain files
                            (NAME#.TAIL or NAME#.out.TAIL)
    TYPE=                   if you set this parameter, then TYPE will be
                            used to name the graphics file (VAR.TYPE) for 
                            each summarized variable 
    WHERE=                  restrict the data with a WHERE clause,
                            useful for removing burn-in,
                            i.e. WHERE=iter>4000
    
    Common OPTIONAL Parameters
    
    LOG=                    set to /dev/null to turn off .log                            
*/
                            
%macro _decoda(infile=REQUIRED, file=&infile, out=REQUIRED, chains=, gsfmode=replace, 
    mu0=0, stats=, tail=txt, type=, where=, log=, chain1=, chain2=, 
    chain3=, chain4=, chain5=, chain6=, chain7=, chain8=, chain9=, chain10=);
    
    %_require(&out &file);

    %if %length(&log) %then %_printto(log=&log);
    
    %local i j head var var0;
    %let file=%scan(&file, 1, ''"");

    %if %length(&chains)=0 %then %let chains=%_count(&chain1 &chain2 
        &chain3 &chain4 &chain5 &chain6 &chain7 &chain8 &chain9 &chain10);
        
    %if &chains=0 %then %let chains=1;
    
    %do i=1 %to &chains;
        %let chain&i=%scan(&&chain&i, 1, ''"");
        
        %if %length(&&chain&i)=0 %then %do;
            %let j=%index(&file, Index.txt);
            
            %if &j %then %let head=%_substr(&file, 1, &j-1);
            %else %let head=%scan(&file, 1, .);

            %let chain&i=&head.&i..&tail;
            
            %if %_exist(&&chain&i)=0 %then %do;
                %let chain&i=&head.&i..txt;
                
                %if %_exist(&&chain&i)=0 %then %do;
                    %let chain&i=&head.&i..out;
            
                    %if %_exist(&&chain&i)=0 %then %do;
                        %let chain&i=&head.&i..out.txt;
                        
                        %if &chains=1 & %_exist(&chain1)=0 %then %do;            
                            %let chain1=&head..&tail;
            
                            %if %_exist(&chain1)=0 %then %do;
                                %let chain1=&head..txt;
                
                                %if %_exist(&chain1)=0 %then %do;
                                    %let chain1=&head..out;
            
                                    %if %_exist(&chain1)=0 %then %let chain1=&head..out.txt;
                                %end;
                            %end;
                        %end;
                        
                        %if %_exist(&&chain&i)=0 %then %do;
                            %put ERROR: only file names like NAMEIndex.txt/NAME#.txt,;
                            %put ERROR: NAME.ind/NAME#.out, and ;
                            %put ERROR: NAME.ind.txt/NAME#.out.txt are supported.; 
                            %put ERROR: Specify the chains manually by CHAIN#=...;
                            %_abend;
                        %end;
                    %end;
                %end;
            %end;
        %end;
        
        %local data&i var&i;
        %let data&i=%_scratch;
        
        data &&data&i;
            infile "&&chain&i" dlm='090D20'x;
            input iter value;
        run;

        data &&data&i;
            drop start stop;
	    length var $ 32;
	    infile "&file" dlm='090D20'x;
	    input var start stop;
        
            retain chain &i;
            
            var=lowcase(translate(compress(var), '___ ', '.[,]'));
            
        %if &i=1 %then %do;
            call symput('var'||left(_n_), trim(var));
            call symput('var0', trim(left(_n_)));
        %end;
    
            do row=start to stop;
                set &&data&i point=row;
                output;
            end;
        run;
    %end;
            
    data &out;
        set %do i=1 %to &chains; &&data&i %end;;
        where &where;
    run;
    
    proc sort data=&out out=&out;
        by chain iter;
    run;
    
    proc transpose data=&out out=&out(sortedby=chain iter drop=_name_);
        by chain iter;
        var value;
        id var;
    run;
    
    %if %length(&stats) %then %do;
        goptions gsfmode=&gsfmode;
        %let stats=%lowcase(%_list(&stats));
            
        %do j=1 %to &var0;
            %let var=&var &&var&j;
        %end;

        %if %_count(&stats)>1 | %sysfunc(indexw(&var, &stats))>0 %then %do;
            %let var=&stats;
            %let var0=%_count(&var);
        %end;
        
        %do j=1 %to &var0;
            %let var&j=%scan(&var, &j, %str( ));
                            
            %if %length(&type) %then filename gsasfile "&&var&j...&type";
            %else %if &j=2 %then goptions gsfmode=append;;
        
            proc univariate loccount mu0=&mu0 plot;
                var &&var&j;
                %if %_version(8) %then histogram &&var&j / kernel;;
            run;
        %end;
    %end;
    %else %do;
        proc contents data=&out;
        run;
    %end;

    %if %length(&log) %then %_printto;
%mend _decoda;

%*VALIDATION TEST STREAM;
/* un-comment to re-validate

%_decoda(out=mydata, chains=2, infile=head.txt);

*/
