%macro _coda(datafile,varlist);
/*This macro is aimed*/
options symbolgen;
*%let datafile=post1;
*%let varlist=mul;

%let leg10=%_nobs(data=&datafile);
%let leg10=&leg10*0.1;
%let leg10=%sysevalf(&leg10);

data first10;
set &datafile(firstobs=1 obs=&leg10);
run;

%let leg50=%_nobs(data=&datafile);
%let leg50=&leg50*0.5;
%let leg50=%sysevalf(&leg50+1);
data last50;
set &datafile (firstobs=&leg50);
run;
/*Calculate the mean for the first 10%*/
proc means data=first10 noprint;
var &varlist;
output out=m10 mean=avg;
run;
data _null_;
set m10;
call symput('avg10',avg);
run;
*%put &avg10;
/*Calculate the mean for the last 50%*/
proc means data=last50 noprint;
var &varlist;
output out=m50 mean=avg50;
run;
data _null_;
set m50;
call symput('avg50',avg50);
run;
*%put &avg50;

/*Calculate the spectral density*/
/*For first 10%*/
proc spectra data=first10 out=b10 p s;
weight qs;
var &varlist;
run;

data b10;
set b10 (firstobs=1 obs=1);
call symput('var10',s_01);
run;
*%put &var10;

/*For last 50%*/
proc spectra data=last50 out=b50 p s;
weight qs;
var &varlist;
run;

data b50;
set b50 (firstobs=1 obs=1);
call symput('var50',s_01);
run;
*%put &var50;
/*the function to calculate the Geweke statistics*/

data temp;
geweke=%geweke(&avg10,&avg50,&var10,&var50,&leg10,&leg50);
output;
run;

proc print data=temp;
run;

proc means data=&datafile noprint;
var &varlist;
output out=avg mean=avg;
run;
data _null_;
set avg;
call symput('avg',avg);
run;
*%put &avg;

data YuMyk;
set &datafile;
mu=&avg;
retain st nmu 0;
st=&varlist+st;
nmu=mu+nmu;
sthat=st-nmu;
N=_N_;
run;

proc gplot data=YuMyk;
plot sthat*N;
run;

data test;
set YuMyk;
stminus1=lag2(&varlist);
stself=lag1(&varlist);
stplus1=&varlist;
keep stminus1 stplus1 stself;
run;

data test;
set test (firstobs=3);
d=0;
if (stself<stminus1 & stself<stplus1) or (stself>stminus1 & stself>stplus1)  then d=1;
run;

proc means data=test;
var d;
run;
%mend _coda;
