%put NOTE: You have called the macro _LEXPORT, 2004-11-05.;
%put NOTE: Copyright (c) 2004 Rodney Sparapani;
%put;

/*
Author:  Rodney Sparapani <rsparapa@mcw.edu>
Created: 2004-00-00

This file is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

In short: you may use this file any way you like, as long as you
don't charge money for it, remove this notice, or hold anyone liable
for its results.
*/

/* _LEXPORT Documentation
    Export a BUGS or R/S+ "list" data file from a SAS Dataset.
    
    REQUIRED Parameters  

    FILE=                   "list" file to create
    VAR=                    list of variables to be included
                            
    Specific OPTIONAL Parameters
                            
    DATA=_LAST_             default SAS dataset used
    FORMAT=best12.          default format for variables
    LINESIZE=80             default line length
    LS=LINESIZE             alias
    N=N                     default name of variable for number of
                            observations
    OUT=DATA                default name of object
    R=                      by default create BUGS-style "list"
                            if set to anything, create a S+/R-style 
    SPLUS=R                 alias
    
    Common OPTIONAL Parameters
    
    LOG=                    set to /dev/null to turn off .log                            
*/

%macro _lexport(file=REQUIRED, var=REQUIRED, data=&syslast, 
    format=best12., linesize=80, ls=&linesize, n=N, out=&data, r=, splus=&r, 
    log=);

%_require(&file &var);

%let file=%scan(&file, 1, ''"");
%let splus=%length(&splus);
        
%if %length(&log) %then %_printto(log=&log);

%local nobs i arg args var0;
%let nobs=%_nobs(data=&data);
%let var=%_list(&var);
%let args=%_count(&var);

%let var0=0;

%do i=1 %to &args;
    %let arg=%scan(&var, &i, %str( ));
    
    %if %index(&arg, .) %then %let format&var0=&arg;
    %else %do;
        %let var0=%eval(&var0+1);
        %local var&var0 format&var0;
        %let var&var0=&arg;
        %let format&var0=&format;
    %end;  
%end;

%do i=1 %to &var0;
proc format;
    value _&i._
        .='NA'
        other=[&&format&i]
    ;
run;
%end;

data _null_;
    file "&file" linesize=&ls;

    put %do i=1 %to &var0-1; "#&&var&i, " %end; "#&&var&var0";
    
    put %if &splus %then "%lowcase(%trim(&out)) <- ";
        "list(&n=&nobs, " @;
    
    %do i=1 %to &var0;
        put "%_tr(&&var&i, from=_, to=.) = c(";
        
        do i=1 to &nobs;
            set &data(keep=&&var&i) point=i;
            
            if i=&nobs then put &&var&i _&i._.-r
                %if &i<&var0 %then '), ';
                %else '))';
            ;
            else put &&var&i _&i._.-r ',' @;
        end;
    %end;

    stop;
run;

%if %length(&log) %then %_printto;

%mend _lexport;

%*VALIDATION TEST STREAM;
/* un-comment to re-validate
%_limport(infile=ratmis-s.dat, file=ratmis.sas, out=ratmis);

proc print data=_last_(obs=10);

%_lexport(file=ratmis.list, data=ratmis, var=x y);

%_limport(infile=ratmis.list, file=ratstruct.sas, out=ratmis);

proc print;
run;

%_limport(infile=alc.tbl, file=alcstuct.sas, out=alc);

%_lexport(file=alc.list, data=alc, var=status alcgrams);

%_limport(infile=alc.list, file=alcstruct.sas, out=alc);

proc print;
run;
*/
