%put NOTE: You have called the macro _SEXPORT, 2004-05-19.;
%put NOTE: Copyright (c) 2004 Rodney Sparapani;
%put;

/*
Author:  Rodney Sparapani <rsparapa@mcw.edu>
Created: 2004-00-00

This file is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

In short: you may use this file any way you like, as long as you
don't charge money for it, remove this notice, or hold anyone liable
for its results.
*/

/* _SEXPORT Documentation
    Export a BUGS or R/S+ "structure" data file from a SAS Dataset.
    
    REQUIRED Parameters  

    FILE=                   "structure" file to create
    VAR=                    list of arrays to be included
                            Ex. two arrays: VAR=one1-one5 two1-two8
                            
    Specific OPTIONAL Parameters
                            

    DATA=_LAST_             default SAS dataset used
    FORMAT=best12.          default format for variables
    LINESIZE=80             default line length
    LS=LINESIZE             alias
    OUT=DATA                default name of object
    R=                      by default create BUGS-style "structure"
                            if set to anything, create a S+/R-style 
    SPLUS=R                 alias
    
    Common OPTIONAL Parameters
    
    LOG=                    set to /dev/null to turn off .log                            
*/

%macro _sexport(file=REQUIRED, var=REQUIRED, data=&syslast,  
    format=best12., linesize=80, ls=&linesize, out=&data,
    r=, splus=&r, log=);

%_require(&file &var);

%let file=%scan(&file, 1, ''"");
%let splus=%length(&splus);
    
%if %length(&log) %then %_printto(log=&log);

%local nobs i j var0 name;
%let nobs=%_nobs(data=&data);
%let var0=%_count(&var);

proc format;
    value __na
        .='NA'
        other=[&format]
    ;
run;

data _null_;
    file "&file" linesize=&ls;

    put %if &splus %then "%lowcase(%trim(&out)) <- "; 
        "list(N=&nobs, T=%_count(%_list(&&var&i)), " @;
    
%do i=1 %to &var0;
    %let var&i=%scan(&var, &i, %str( ));
    %let j=%_indexc(&&var&i, 0123456789);
    %let name=%_substr(&&var&i, 1, &j-1);

    put "%_tr(&name, from=_, to=.) = structure(.Data = c(";
        
        do i=1 to &nobs;
            set &data(keep=&&var&i) point=i;
            
            put (&&var&i) (__na.-r ',') @;
            
            if i=&nobs then put '), ' @;
            else put ',' @;
        end;
    
        put %if &splus %then ".Dim = c(%_count(%_list(&&var&i)), &nobs))";
            %else ".Dim = c(&nobs, %_count(%_list(&&var&i))))";
            %if &i=&var0 %then ')';
            %else ',';
        ; 
%end;
        
    stop;
run;

%if %length(&log) %then %_printto;

%mend _sexport;

%*VALIDATION TEST STREAM;
/* un-comment to re-validate
            
data matrix;
    input col1-col5;
    datalines;
    1 2 3 4 5
    6 7 8 9 10
run;

%_sexport(data=matrix, var=col1-col5, file=_sexport.txt);
%_sexport(data=matrix, var=col1-col5, file=_sexport.r, r=1);

*/
