%put NOTE: You have called the macro _LIMPORT, 2004-03-04.;
%put NOTE: Copyright (c) 2001-2004 Rodney Sparapani;
%put;

/*
Author:  Rodney Sparapani <rsparapa@mcw.edu>
Created: 2001-00-00

This file is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

In short: you may use this file any way you like, as long as you
don't charge money for it, remove this notice, or hold anyone liable
for its results.
*/

/* _LIMPORT Documentation
    Import a R/S+/BUGS "list" data file into a SAS Dataset.
    
    REQUIRED Parameters  

    INFILE=                 "list" file to read
    OUT=                    SAS dataset created
                            
    Specific OPTIONAL Parameters
                            
    FILE=SYSJOBID.sas       SAS/IML program created to read
                            "list" file; run automatically;
                            if program fails, edit and run
                            manually
    
    Common OPTIONAL Parameters
    
    LOG=                    set to /dev/null to turn off .log                            
*/

%macro _limport(infile=REQUIRED, out=REQUIRED, file=&sysjobid..sas, log=);

%_require(&infile &out);

%let infile=%scan(&infile, 1, ''"");
%let file=%scan(&file, 1, ''"");
    
%if %length(&log) %then %_printto(log=&log);

data _null_;
    file "&file";
    infile "&infile" length=pos dlm='0d0a'x end=lastrec;
    length string $ 200;
    retain paren 1;
    drop i;

    input @;
    input string $varying. pos;

    if _n_=1 then do;
        put 'proc iml;';
        
        pos=index(string, 'list(');

        if pos>1 then do;
            do i=1 to pos-1;
                paren=paren+(substr(string, i, 1)='(');
            end;
        end;

        if pos then do;
            if length(string)>pos+5 then string=substr(string, pos+5);
            else string='';
        end;
    end;

    pos=indexc(string, '()');

    do while(pos);
        if length(string)>=pos+2 & substr(string, pos, 3)=')),' then do;
            paren=paren-2;
            substr(string, pos, 3)=' };';
        end;
        else if length(string)>=pos+1 & 
            (substr(string, pos, 2)='),' | substr(string, pos, 2)='))') then do;
            paren=paren-1;
            substr(string, pos, 2)='};';
        end;
        else if substr(string, pos, 1)=')' then do;
            paren=paren-1;

            if paren=0 then substr(string, pos, 1)=';';
            else substr(string, pos, 1)='}';
        end;
        else do;
            paren+1;
            substr(string, pos-1, 2)=' {';
        end;
    
        pos=indexc(string, '()');
    end;

    pos=index(string, 'NA');
    
    do while(pos);
        substr(string, pos, 2)=' .';     
        pos=index(string, 'NA');
    end;
    
    pos=indexw(string, 'row.names');

    if pos then substr(string, pos, 9)=' rownames';

    put string;
        
    if lastrec then put "create &out var _all_; append var _all_; quit;";
run;

%include "&file";

%if %length(&log) %then %_printto;

%mend _limport;

%*VALIDATION TEST STREAM;
/* un-comment to re-validate
%_limport(file=ratmis.sas, infile=ratmis-s.dat, out=ratmis);

proc print data=ratmis;
run;

%_limport(file=alc.sas, infile=alc.tbl, out=alc);

proc print data=alc;
run;
*/


